import misc.Debug;
import types.Rahmen;
import java.awt.Image;
import java.awt.Frame;



public class Computer extends SystemObject {
    public Channel          m_Channel;
    public Protocol         m_Protocol;
    public Image            m_Image;
    protected Timer         m_Timer;
    protected int           m_iSpeed;
    StringBuffer            m_SendPool;     // The Pool of data to be transmitted
    public int              m_iSendIndex;   // Index into the Pool of data
    StringBuffer            m_ReceivePool;  // The Pool of data received
    public Computer() {
    }
    public void init(Image image,Channel a,Protocol b) {
        m_Channel = a;
        m_Image = image;
        m_Timer = new Timer(this);
        setData("This_is_the_data_which_is_transmitted");
        setProtocol(new SelectiveRepeat(this));
        m_iSendIndex = 0;
        m_ReceivePool = new StringBuffer(100);
    }
    public void setProtocol(Protocol protocol) {
        m_Protocol = protocol;
        m_Timer.removeAll();
        m_iSendIndex = -1;
    }
    public void setSpeed(int iSpeed) {
        m_iSpeed = iSpeed;
    }
    public int getSpeed() {
        return(m_iSpeed);
    }
    public void upperLayerSend() {
        m_Protocol.m_Event = Protocol.FRAME_FROM_UPPERLAYER;
        m_Protocol.Work();
    }
    public void upperLayerReceive() {
        m_Protocol.m_Event = Protocol.FRAME_TO_UPPERLAYER;
        m_Protocol.Work();
    }
    public void lowerLayerSend(Rahmen frame) {
        m_Channel.sendFrame(this,frame);
    }
    public void lowerLayerReceive(Rahmen frame) {
        try {
            m_Protocol.m_Frame = (Rahmen)frame.clone();
        }
        catch (CloneNotSupportedException e) {};
        m_Protocol.m_Event = Protocol.FRAME_FROM_LOWERLAYER;
        m_Protocol.Work();
    }
    public void timeOut(int iID) {
        m_Protocol.m_Event = Protocol.TIME_OUT;
        m_Protocol.m_iPar1 = iID;
        m_Protocol.Work();
    }
    public Protocol protocol() {
        return(m_Protocol);
    }
    public Timer timer() {
        return(m_Timer);
    }
    public void setData(String data) {
        m_SendPool = new StringBuffer(data);
        m_iSendIndex = -1;
    }
    public char getData() {
        // Check if String wrapps around
        if ((m_iSendIndex>=m_SendPool.length())||(m_iSendIndex<-1)) {
            m_iSendIndex=-1;
        }
        if (m_iSendIndex==-1) {
            // Clear the receivers buffer
            m_iSendIndex++;
            return('#');
        }
        return(m_SendPool.charAt(m_iSendIndex++));
    }
    public void writeData(char data) {
        m_ReceivePool.append(data);
        if (data=='#') {
            // the data has completly arrived, verify it
            if (m_ReceivePool.toString()==m_SendPool.toString()) {
                Frame frame = new Frame("Hallo Fehler");
                frame.resize(200,200);
                frame.show();
            }
            m_ReceivePool.setLength(0);
        }
    }

}

